// SampleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Sample.h"
#include "SampleDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSampleDlg dialog

CSampleDlg::CSampleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSampleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSampleDlg)
	m_strPort = _T("");
	m_strTrack1 = _T("");
	m_strTrack2 = _T("");
	m_strTrack3 = _T("");
	m_strFullTrack = _T("");
	m_bMsrMsgUsed = FALSE;
	m_iMethodOption = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSampleDlg)
	DDX_Text(pDX, IDC_EDIT_PORTNAME, m_strPort);
	DDX_Text(pDX, IDC_STATIC_1, m_strTrack1);
	DDX_Text(pDX, IDC_STATIC_2, m_strTrack2);
	DDX_Text(pDX, IDC_STATIC_3, m_strTrack3);
	DDX_Text(pDX, IDC_EDIT_FULLDATA, m_strFullTrack);
	DDX_Check(pDX, IDC_CHECK_MSRMSG, m_bMsrMsgUsed);
	DDX_Radio(pDX, IDC_RADIO2, m_iMethodOption);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSampleDlg, CDialog)
	//{{AFX_MSG_MAP(CSampleDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_OPENPORT, OnButtonOpenport)
	ON_BN_CLICKED(IDC_BUTTON_CLOSEPORT, OnButtonCloseport)
	ON_BN_CLICKED(IDC_BUTTON_FEED, OnButtonFeed)
	ON_BN_CLICKED(IDC_BUTTON_BITMAP, OnButtonBitmap)
	ON_BN_CLICKED(IDC_BUTTON_BARCODE, OnButtonBarcode)
	ON_BN_CLICKED(IDC_BUTTON_PRINTTEXT, OnButtonPrinttext)
	ON_BN_CLICKED(IDC_BUTTON_STATUS, OnButtonStatus)
	ON_BN_CLICKED(IDC_BUTTON_PROPERTY, OnButtonProperty)
	ON_BN_CLICKED(IDC_BUTTON_DIRECTIO, OnButtonDirectio)
	ON_BN_CLICKED(IDC_BUTTON_NEXTPRNPOS, OnButtonNextprnpos)
	ON_BN_CLICKED(IDC_BUTTON_MSRSTART, OnButtonMsrstart)
	ON_BN_CLICKED(IDC_CHECK_MSRMSG, OnCheckMsrmsg)
	ON_BN_CLICKED(IDC_BUTTON_MSRCANCEL, OnButtonMsrcancel)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSampleDlg message handlers

BOOL CSampleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_strPort = "COM1:115200";

	GetDlgItem(IDC_BUTTON_FEED)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_BITMAP)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_BARCODE)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_PRINTTEXT)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_STATUS)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_PROPERTY)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_DIRECTIO)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_NEXTPRNPOS)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_MSRSTART)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_MSRCANCEL)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON1)->EnableWindow(FALSE);
	m_bMode = FALSE;
	UpdateData(FALSE);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSampleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSampleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSampleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSampleDlg::OnButtonOpenport() 
{
	UpdateData(TRUE);
	
	long lResult = 0;

 	lResult = PrinterOpen(m_strPort, 1000);	

	if(lResult != BXL_SUCCESS && lResult != BXL_WATING_OPEN)
	{
		CString strdata;
		strdata.Format("Error Code = %d", lResult);
		AfxMessageBox(strdata);		
		return ;
	}
	
 
	GetDlgItem(IDC_BUTTON_FEED)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUTTON_BITMAP)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUTTON_BARCODE)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUTTON_PRINTTEXT)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUTTON_STATUS)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUTTON_PROPERTY)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUTTON_DIRECTIO)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUTTON_NEXTPRNPOS)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUTTON_MSRSTART)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUTTON_MSRCANCEL)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUTTON1)->EnableWindow(TRUE);
}

void CSampleDlg::OnButtonCloseport() 
{
	
	PrinterClose();

	GetDlgItem(IDC_BUTTON_FEED)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_BITMAP)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_BARCODE)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_PRINTTEXT)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_STATUS)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_PROPERTY)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_DIRECTIO)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_NEXTPRNPOS)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_MSRSTART)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_MSRCANCEL)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON1)->EnableWindow(FALSE);
}

void CSampleDlg::OnButtonFeed() 
{
	
	LineFeed(10);
	
}

void CSampleDlg::OnButtonBitmap() 
{
	CString strError;
	long lResult = 0;
	lResult = CheckPrinter();
	//Printer State Check
	if( lResult != BXL_SUCCESS)
	{		
		strError.Format("Printer is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	lResult = GetStat();
	if( lResult != BXL_STS_NORMAL)
	{
		strError.Format("Printer State is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	CString strFile;
	CFileDialog FileDlg(TRUE, "", strFile, OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT, "Image File(*.bmp)|*.bmp|Image File(*.jpg)|*.jpg|Image File(*.gif)|*.gif||");
	
	if(FileDlg.DoModal() == IDOK)
	{
		strFile = FileDlg.GetPathName();
	}else
		return;

	PrintBitmap(strFile, 300, BXL_ALIGNMENT_CENTER, 50);
	
}

void CSampleDlg::OnButtonBarcode() 
{
	CString strError;
	long lResult = 0;
	lResult = CheckPrinter();
	//Printer State Check
	if( lResult != BXL_SUCCESS)
	{		
		strError.Format("Printer is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	lResult = GetStat();
	if( lResult != BXL_STS_NORMAL)
	{
		strError.Format("Printer State is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}
	int i = 0;
	//UPCA Printing

	for(i = 2; i < 7; i+=2 )
	{	
		PrintText("BARCODE : UPCA", BXL_ALIGNMENT_LEFT, 0,0);
		PrintBarcode("123456789012", BXL_BCS_UPCA, 50, i, BXL_ALIGNMENT_LEFT, BXL_BC_TEXT_NONE);	
		LineFeed(2);		
	}
  
	//UPCE Printing
	for(i = 2; i < 7; i+=2 )
	{	
		PrintText("BARCODE : UPCE", BXL_ALIGNMENT_LEFT, 0,0);
		PrintBarcode("012345678901", BXL_BCS_UPCE, 50, i, BXL_ALIGNMENT_LEFT, BXL_BC_TEXT_NONE);
		LineFeed(2);		
	}	
	
	//JAN,EAN8 Printing	
	for(i = 2; i < 7; i+=2 )
	{	
		PrintText("BARCODE : JAN/EAN8", BXL_ALIGNMENT_LEFT, 0,0);
		PrintBarcode("12345678", BXL_BCS_JAN8, 50, i, BXL_ALIGNMENT_RIGHT, BXL_BC_TEXT_ABOVE);
		LineFeed(2);		
	}
	

	//JAN,EAN8 Printing	
	for(i = 2; i < 7; i+=2 )
	{	
		PrintText("BARCODE : JAN/EAN13\n", BXL_ALIGNMENT_LEFT, 0,0);
		PrintBarcode("1234567890123", BXL_BCS_EAN13, 50, i, BXL_ALIGNMENT_LEFT, BXL_BC_TEXT_NONE);
		LineFeed(2);		
	}
	
	for(i = 2; i < 7; i+=2 )
	{	
		PrintText("BARCODE : CODE39\n", BXL_ALIGNMENT_LEFT, 0,0);
		PrintBarcode("12", BXL_BCS_Code39, 50, i, BXL_ALIGNMENT_LEFT, BXL_BC_TEXT_NONE);
		LineFeed(2);		
	}
	
	for(i = 2; i < 7; i+=2 )
	{	
		PrintText("BARCODE : ITF\n", BXL_ALIGNMENT_LEFT, 0,0);
		PrintBarcode("1234", BXL_BCS_ITF, 50, i, BXL_ALIGNMENT_LEFT, BXL_BC_TEXT_NONE);
		LineFeed(2);		
	}
	

	
}

void CSampleDlg::OnButtonPrinttext() 
{
CString strError;
	long lResult = 0;
	lResult = CheckPrinter();
	//Printer State Check
	if( lResult != BXL_SUCCESS)
	{		
		strError.Format("Printer is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	lResult = GetStat();
	if( lResult != BXL_STS_NORMAL)
	{
		strError.Format("Printer State is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	CHAR t[10] = "Receipt";
	PrintText(t, BXL_ALIGNMENT_CENTER, BXL_FT_BOLD | BXL_FT_UNDERLINE, BXL_TS_1WIDTH | BXL_TS_1HEIGHT);	
	PrintText(" \n\n", BXL_ALIGNMENT_CENTER, BXL_FT_BOLD | BXL_FT_UNDERLINE, BXL_TS_1WIDTH | BXL_TS_1HEIGHT);	
	
	PrintText("------------------------------\n", BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH | BXL_TS_0HEIGHT);
	PrintText(" Apple      3             $3.0\n", BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);
	PrintText(" Cola       1             $1.2\n", BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText(" Milk       2             $1.8\n", BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText(" Juice      1             $2.0\n", BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText("------------------------------\n", BXL_ALIGNMENT_CENTER, BXL_FT_DEFAULT, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText(" Total                    $8.0\n", BXL_ALIGNMENT_CENTER, BXL_FT_BOLD, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText(" Cash                     $8.0\n", BXL_ALIGNMENT_CENTER, BXL_FT_BOLD, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText("                          $0.0\n", BXL_ALIGNMENT_CENTER, BXL_FT_BOLD, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	

	//////////////////////////////////////////////////////////////////////////
	//Set multi attribute in one line.
	PrintText("Test", BXL_ALIGNMENT_CENTER, BXL_FT_BOLD, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText("BBB", BXL_ALIGNMENT_CENTER, BXL_FT_FONTB | BXL_FT_BOLD, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText("CCC", BXL_ALIGNMENT_CENTER, BXL_FT_FONTB | BXL_FT_REVERSE, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText("DDD", BXL_ALIGNMENT_CENTER, BXL_FT_BOLD | BXL_FT_UNDERLINE, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	
	PrintText("\n", BXL_ALIGNMENT_CENTER, BXL_FT_BOLD | BXL_FT_UNDERLINE, BXL_TS_0WIDTH|BXL_TS_0HEIGHT);	

	PrintBarcode("12345678", BXL_BCS_ITF, 100, 2, BXL_ALIGNMENT_CENTER, BXL_BC_TEXT_BELOW);

	lResult = LineFeed(5);
	if(lResult != BXL_SUCCESS)
	{
		AfxMessageBox("Error LineFeeding");
	}
	
}

void CSampleDlg::OnButtonStatus() 
{
	long lResult = CheckPrinter();
	if(lResult == BXL_NOT_OPENED)
		return;
	int lState = (int)GetStat();
	CString strStatus;
	
	strStatus = "Printer Status =";
	if( (lState & BXL_STS_PAPEREMPTY)	== BXL_STS_PAPEREMPTY)
	{
		strStatus += "PaperEmpty ";
	}

	if( (lState & BXL_STS_COVEROPEN)	== BXL_STS_COVEROPEN)
	{
		strStatus += "CoverOpen ";
	}

	if( (lState & BXL_STS_MSR_READY)	== BXL_STS_MSR_READY)
	{
		strStatus += "MSRReady ";
	}	

	if( (lState & BXL_STS_ERROR)	== BXL_STS_ERROR)
	{
		strStatus += "Error ";
	}

	if( (lState & BXL_STS_NOT_OPEN)	== BXL_STS_NOT_OPEN)
	{
		strStatus += "NotOpenPort ";
	}

	if( lState== BXL_STS_NORMAL)
	{
		strStatus += "Normal ";
	}

	long lPower = GetPowerValue();

	switch(lPower)
	{
	case BXL_PWR_HIGH:		
		strStatus += "\r\nPower Status:HIGH";
		break;
	case BXL_PWR_MIDDLE:
		strStatus += "\r\nPower Status:MIDLE";
		break;
	case BXL_PWR_LOW:
		strStatus += "\r\nPower Status:LOW";
		break;
	case BXL_PWR_SMALL:
		strStatus += "\r\nPower Status:SMALL";
		break;
	case BXL_PWR_NOT:	
		strStatus += "\r\nPower Status:Empty";
		break;
	default :
		strStatus += "\r\nPower Status:Unknown";
		break;
		
	}
	AfxMessageBox(strStatus	);
	
}

void CSampleDlg::OnButtonProperty() 
{
	SetCharacterSet(1); //katakana
	//SetCharacterSet(437); //USA : Default CodePage

	for(int i = 128; i < 256; i++)
	{
		CString strText;
		strText.Format("%c\n",i);
		PrintText(strText, BXL_ALIGNMENT_LEFT, 0, 0);
	}
}

void CSampleDlg::OnButtonDirectio() 
{
	CHAR dbRead = 0;
	UINT dwRead = 1;
	
	CHAR dbCmd[3] = {0x10, 0x04, 0x02};
	long lResult = DirectIO(dbCmd,3, &dbRead, dwRead);

	if(lResult != BXL_SUCCESS)
	{
		CString strEr;
		strEr.Format("Error code = %d", lResult);
		AfxMessageBox(strEr);		
		return;
	}else
	{
		CString strRet ;
		strRet.Format("Readdata Read %02x",dbRead);	
		AfxMessageBox(strRet);
	
	}

	
	
}

void CSampleDlg::OnButtonNextprnpos() 
{
	NextPrintPos();
	
}

void CSampleDlg::OnButtonMsrstart() 
{
	
	KillTimer(100);
	m_bMode = FALSE;
	MsrReadReady();	
	if(GetStat() != BXL_STS_MSR_READY)
	{
		m_strTrack1.Format("Not MSR Ready Mode : %d", GetStat());
		UpdateData(FALSE);
		return;
	}	

	UpdateData(TRUE);
	if(!m_bMsrMsgUsed)
	{
		if(m_iMethodOption == 0)
			SetTimer(100,100, NULL);		
		else
			SetTimer(1000, 100, NULL);
	}
	
}

void CSampleDlg::OnCheckMsrmsg() 
{
	if(m_bMsrMsgUsed)
		m_bMsrMsgUsed = FALSE;
	else
	{
		AfxMessageBox(TEXT("If you installed security software, It will not send MSR message."));
		m_bMsrMsgUsed = TRUE;
		SetMsrMsgMode(m_bMsrMsgUsed);
	}
	
}

void CSampleDlg::OnButtonMsrcancel() 
{
	m_bMode = TRUE;
	UpdateData(TRUE);
	if(!m_bMsrMsgUsed)
	{	
		if(m_iMethodOption == 0)
			KillTimer(100);		
		else
			KillTimer(1000);	
	}

	m_strTrack1 = L"- Cancel to Read Card";				
	UpdateData(FALSE);
	MsrReadCancel();	
}

void CSampleDlg::OnTimer(UINT nIDEvent) 
{
	
	// if you set sentinel option, you could allocate enough memory.
	CHAR dbTrack1[200];
	CHAR dbTrack2[200];
	CHAR dbTrack3[200];

	BOOL bTrack1 = FALSE;
	BOOL bTrack2 = FALSE;
	BOOL bTrack3 = FALSE;
	memset(dbTrack1, 0, sizeof(dbTrack1));
	memset(dbTrack2, 0, sizeof(dbTrack2));
	memset(dbTrack3, 0, sizeof(dbTrack3 ));		
	
	if(nIDEvent != 100)
	{
		KillTimer(1000);
		CHAR dbFullTrack[600];
		memset(dbFullTrack, 0, 600);
		if( MsrReadFullTrack(dbFullTrack, 600) != BXL_SUCCESS)
		{
			m_strFullTrack = TEXT("Wait to swipe card");
			m_strTrack1 = "";		
			m_strTrack2 = "..";	
			m_strTrack3 = "";
			UpdateData(FALSE);
			SetTimer(1000, 100, NULL);
			return;		
		}else
		{	
			m_strTrack1 = "Use MsrReadFullTrack Functions";
			m_strFullTrack = dbFullTrack;			
			UpdateData(FALSE);
			
		}
		
		return;
	}

	KillTimer(100);
	long lResult = MsrReadTrack(dbTrack1, dbTrack2, dbTrack3);
	if(lResult == BXLMSR_DATAEMPTY)
	{		
		if(!m_bMode){
			m_strTrack1 = "Wait to Read Card";		
			m_strTrack2 = "..";				
			UpdateData(FALSE);

		
			SetTimer(100,100, NULL);				
		}else
		{
			m_strTrack1 = L"Cancel to Read Card";				
			UpdateData(FALSE);
		}		
		return;		
	}else
	{
		CString strData1(dbTrack1);
		m_strTrack1 = strData1;
		CString strData2(dbTrack2);
		m_strTrack2 = strData2;
		CString strData3(dbTrack3);
		m_strTrack3 = strData3;			
	}

	
	
	UpdateData(FALSE);
	
	CDialog::OnTimer(nIDEvent);
}

BOOL CSampleDlg::PreTranslateMessage(MSG* pMsg) 
{
	// If You installed security software. it can't receive Brocast Message for MSR.
	if(pMsg->message == WM_MSR_ARRIVED && pMsg->lParam == BXL_LPARAM_MSR )
	{			
		if(pMsg->wParam & BXL_MSG_TRACK1)
			m_strTrack1 = GetTrack1();
		
		if(pMsg->wParam & BXL_MSG_TRACK2)
			m_strTrack2 = GetTrack2();

		if(pMsg->wParam & BXL_MSG_TRACK3)
			m_strTrack3 = GetTrack3();

		UpdateData(FALSE);
	}
	
	return CDialog::PreTranslateMessage(pMsg);
}

void CSampleDlg::OnButton1() 
{
	CString strError;
	long lResult ;

	//////////////////////////////////////////////////////////////////////////
	
	lResult = PrintText("BARCODE : PDF417\n", BXL_ALIGNMENT_LEFT, 0,0);
	if(lResult != BXL_SUCCESS)
	{
		strError.Format("PrintTExt is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	lResult = PrintBarcode("12345647890123456478901234564789012345647890", BXL_BCS_PDF417, 255, 2, BXL_ALIGNMENT_LEFT, BXL_BC_TEXT_NONE);		
	if(lResult != BXL_SUCCESS)
	{
		strError.Format("PrintBarcode is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	lResult = PrintBarcode("12345647890123456478901234564789012345647890", BXL_BCS_PDF417, 255, 3, BXL_ALIGNMENT_LEFT, BXL_BC_TEXT_NONE);		
	if(lResult != BXL_SUCCESS)
	{
		strError.Format("PrintBarcode is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}
	LineFeed(2);	

	//////////////////////////////////////////////////////////////////////////
	lResult = PrintText("BARCODE : QRCode\n", BXL_ALIGNMENT_LEFT, 0,0);
	if(lResult != BXL_SUCCESS)
	{
		strError.Format("PrintTExt is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	int i = 0;
	for(i =0; i<8; i++)
	{
		lResult = PrintBarcode("12345647890123456478901234564789012345647890", BXL_BCS_QRCODE_MODEL1, 255, i, BXL_ALIGNMENT_LEFT, BXL_BC_TEXT_NONE);		
		if(lResult != BXL_SUCCESS)
		{
			strError.Format("PrintBarcode is Error = %d", lResult);
			AfxMessageBox(strError);
			return;
		}
	}

	for(i = 0; i<8; i++)
	{
		lResult = PrintBarcode("12345647890123456478901234564789012345647890", BXL_BCS_QRCODE_MODEL2, 255, i, BXL_ALIGNMENT_LEFT, BXL_BC_TEXT_NONE);		
		if(lResult != BXL_SUCCESS)
		{
			strError.Format("PrintBarcode is Error = %d", lResult);
			AfxMessageBox(strError);
			return;
		}
	}
	LineFeed(2);	
	//////////////////////////////////////////////////////////////////////////

	lResult = PrintText("BARCODE : DataMatrix\n", BXL_ALIGNMENT_LEFT, 0,0);
	if(lResult != BXL_SUCCESS)
	{
		strError.Format("PrintTExt is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	for(i=2; i<7; i++)
	{
		lResult = PrintBarcode("12345647890123456478901234564789012345647890", BXL_BCS_DATAMATRIX, 255, i, BXL_ALIGNMENT_LEFT, BXL_BC_TEXT_NONE);		
		if(lResult != BXL_SUCCESS)
		{
			strError.Format("PrintBarcode is Error = %d", lResult);
			AfxMessageBox(strError);
			return;
		}
	}
	LineFeed(2);	
	//////////////////////////////////////////////////////////////////////////

	lResult = PrintText("BARCODE : MaxiCode\n", BXL_ALIGNMENT_LEFT, 0,0);
	if(lResult != BXL_SUCCESS)
	{
		strError.Format("PrintTExt is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	lResult = PrintBarcode("[)>\x1E\x30\x31\x1D\x39\x36TABCDE\x1D\x30\x30\x37\x1d\x32\x35\x30\x1dTTTBCDE12345647890123456478901234564789012345647890", BXL_BCS_MAXICODE_MODE2, 255, 2, BXL_ALIGNMENT_LEFT, BXL_BC_TEXT_NONE);		
	if(lResult != BXL_SUCCESS)
	{
		strError.Format("PrintBarcode is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	lResult = PrintBarcode("[)>\x1E\x30\x31\x1D\x39\x36TAE\x1D\x30\x30\x37\x1d\x32\x35\x30\x1dTTT12345647890123456478901234564789012345647890", BXL_BCS_MAXICODE_MODE3, 255, 2, BXL_ALIGNMENT_LEFT, BXL_BC_TEXT_NONE);		
	if(lResult != BXL_SUCCESS)
	{
		strError.Format("PrintBarcode is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	lResult = PrintBarcode("12345647890123456478901234564789012345647890", BXL_BCS_MAXICODE_MODE4, 255, 2, BXL_ALIGNMENT_CENTER, BXL_BC_TEXT_NONE);		
	if(lResult != BXL_SUCCESS)
	{
		strError.Format("PrintBarcode is Error = %d", lResult);
		AfxMessageBox(strError);
		return;
	}

	LineFeed(2);	

}
